// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.1 Page 608
// Title: Internal Energy, Enthalpy, Density, and Entropy for an Ideal Gas
//========================================================================
model Ex11_1

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real U(unit = "ft.lb/lbm")"Change in internal energy";
Real S(unit = "ft.lb/lbm.R")"Change in entropy";
Real H(unit = "ft.lb/lbm")"Change in enthalpy";
Real rho(unit = "lbm/ft^3")"Change in density";
Real cv(unit = "ft.lb/lbm.R")"Constant volume ratio";

//=============
// Parameter Section 

parameter Real T1(unit = "R")=540"Temperature in section 1";
parameter Real T2(unit = "R")=453"Temperature in section 2";
parameter Real P1(unit = "psi")=100"Pressure in section 1";
parameter Real P2(unit = "psi")=18.4"Pressure in section 2";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real R(unit = "ft.lb/lbm.R")=53.3"Gas constant";

//=============
// Equation Section 

equation

cv = (R)/(k-1);//Calculation of constant volume ratio

U = cv*(T2-T1);//Calculation of change in internal energy

H = (k*cv)*(T2-T1);//Calculation of change in enthalpy

rho = (1/R)*(((P2*144)/T2)-((P1*144)/T1));//Calculation of change in density
//Note: The terms P1,P2 are multiplied by 144 to convert to lb/ft^2

S = (((k*cv)*log(T2/T1)) - (R*log(P2/P1)));//Calculation of change in entropy

end Ex11_1;
//===================================================================
