// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.3 Page 620
// Title: Mach Cone
//========================================================================
model Ex11_3

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real C(unit = "m/s")"Speed of sound";
Real V(unit = "m/s")"Speed of aircraft";
Real t(unit = "s")"Time taken for aircraft to pass overhead";

//=============
// Parameter Section 

parameter Real z(unit = "m")=1000"Altitude of aircraft";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real M(unit = "")=1.5"Mach Number";

//=============
// Equation Section 

equation

C = 343.3;//Calculation of speed of sound
//Note: The value for speed of sound is obtained from Table B.4 for given condition

V = M*C;//Calculation of speed of aircraft

M = 1/(sin(atan(z/(V*t))));//Calculation of time required to fly overhead

end Ex11_3;
//===================================================================
