// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.7 Page 637
// Title: Area Ratio Function and Flow in a Converging-Diverging Passage
//========================================================================
model Ex11_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real T1(unit = "K")"Temperature at section 1";
Real T2(unit = "K")"Temperature at section 2";
Real T3(unit = "K")"Temperature at section 3";
Real Tth(unit = "K")"Temperature at throat";
Real Pth(unit = "kPa")"Pressure at throat";
Real P1(unit = "kPa")"Pressure at section 1";
Real P2(unit = "kPa")"Pressure at section 2";
Real P3(unit = "kPa")"Pressure at section 3";
Real Mth(unit = "")"Mach Number at throat";
Real M1(unit = "")"Mach Number at section 1";
Real M2(unit = "")"Mach Number at section 2";
Real M3(unit = "")"Mach Number at section 3";

//=============
// Parameter Section 

parameter Real Ath(unit = "m^2")=0.001"Area of the throat";
parameter Real A1(unit = "m^2")=0.002"Area of the section 1";
parameter Real A3(unit = "m^2")=0.003"Area of the section 3";
parameter Real Po(unit = "kPa")=100"Stagnation Pressure";
parameter Real To(unit = "K")=293.2"Stagnation Temperature";

//=============
// Equation Section 

equation

Mth = 1;//Calculation of Mach Number at throat
//Note: There is a transition from subsonic to supersonic flow in nozzle at throat

Pth = Po*0.5283;//Calculation of pressure at throat
//Note: The value of pressure ratio (0.5283) for Mth value in Table D.I

Tth = To*0.8333;//Calculation of temperature at throat
//Note: The value of temperature ratio (0.8333) for Mth value in Table D.I

M1 = 2.20;//Calculation of mach number at section 1
//Note:The value of M1 is obtained for area ratio (A1/Ath) in Table D.I

P1 = Po*0.0935;//Calculation of pressure at section 1
//Note: The value of pressure ratio (0.0935) for M1 value in Table D.I

T1 = To*0.5081;//Calculation of temperature at section 1
//Note: The value of temperature ratio (0.5081) for M1 value in Table D.I

P2 = P1*5.480;//Calculation of pressure at section 2
//Note: The value of pressure ratio (5.480) for M1 value in Table D.S

T2 = T1*1.857;//Calculation of temperature at section 2
//Note: The value of temperature ratio (1.857) for M1 value in Table D.S

M2 = 0.547;//Calculation of mach number at section 2
//Note:The value of M1 is obtained for area ratio (1.888) in Table D.I

M3 = 0.326;//Calculation of mach number at section 3
//Note:The value of M1 is obtained for area ratio (1.259) in Table D.I

P3 = P2*(0.9290/0.8159);//Calculation of pressure at section 3
//Note: The value of pressure ratio (0.9290/0.8159) for M3 value in Table D.S

T3 = To*0.9792;//Calculation of temperature at section 3
//Note: The value of temperature ratio (0.9792) for M3 value in Table D.S

end Ex11_7;
//===================================================================
