// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.9 Page 646
// Title: Converging and Converging—Diverging Nozzles
//========================================================================
model Ex11_9

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real ma(unit = "lbm/s")"Mass flowrate for config. a";
Real mb(unit = "lbm/s")"Mass flowrate for config. b";

//=============
// Parameter Section 

parameter Real Po(unit = "psi")=20"Stagnation Pressure";
parameter Real To(unit = "R")=560"Stagnation Temperature";
parameter Real Aoa(unit = "in^2")=0.01"Outside area for config. a";
parameter Real Aia(unit = "in^2")=0.02"Inside area for config. a";
parameter Real Aob(unit = "in^2")=0.02"Outside area for config. a";
parameter Real Aib(unit = "in^2")=0.01"Inside area for config. b";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real R(unit = "ft.lb/lbm.R")=53.35"Gas constant";

//=============
// Equation Section 

equation

mb = (0.6847*Po*Aib*sqrt(32.2))/sqrt(R*To);//Calculation of mass flow rate for config. b

ma = ((Po*Aib*sqrt(32.2))/sqrt(R*To))*((sqrt(k)*0.686)*(1+((0.2*(0.686)^2)))^(-3));//Calculation of mass flow rate for config. a

end Ex11_9;
//===================================================================
