// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-12: Turbomachines
//Example: 12.5 Page 701
// Title: Use of Pump Scaling Laws
//========================================================================
model Ex12_5

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real H(unit = "ft")"Head Rise";
Real Q(unit = "ft^3/s")"Flow rate";
Real W_shaft(unit = "hp")"Power of shaft";


//=============
// Parameter Section 

parameter Real D(unit = "in")=8"Diameter ofthe pump";
parameter Real S(unit = "rpm")=1200"Speed of the pump";
parameter Real Cq(unit = "")=0.0625"Peak Efficiency - Flowrate";//Refer Fig12.17b Page No. 701
parameter Real Cp(unit = "")=0.014"Peak Efficiency - Power";//Refer Fig12.17b Page No. 701
parameter Real Ch(unit = "")=0.19"Peak Efficiency - Head rise";//Refer Fig12.17b Page No. 701
parameter Real rho(unit = "slug/ft^3")=1.94"Density of water";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation

Q = Cq*(S*(2*pi/60))*(D/12)^3;//Calculation of flow rate
//Note: Division of term D by 12 to convert to ft
//      Multiplication of term S by (2*pi/60) to convert to rad/s

H = (Ch*(S*(2*pi/60))^2*(D/12)^2)/g;//Calculation of head rise
//Note: Division of term D by 12 to convert to ft
//      Multiplication of term S by (2*pi/60) to convert to rad/s

W_shaft = (Cp*rho*(S*(2*pi/60))^3*(D/12)^5)/550;//Calculation of power of shaft
//Note: Division of term D by 12 to convert to ft
//      Multiplication of term S by (2*pi/60) to convert to rad/s

end Ex12_5;
//===================================================================
