// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-12: Turbomachines
//Example: 12.7 Page 715
// Title: Axial-Flow Impulse Turbine (Dental Drill)
//========================================================================
model Ex12_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P(unit = "ft.lb/lbm")"Power of shaft";


//=============
// Parameter Section 

parameter Real ro(unit = "in")=0.168"radius of blade tip";
parameter Real ri(unit = "in")=0.133"radius of blade base";
parameter Real S(unit = "rpm")=300000"Speed of the turbine";

//=============
// Equation Section 

equation

P = -2*(((S*(2*pi/60))*((ro+ri)/(2*12)))^2)/32.174;//Calculation of power of shaft
//Note: Division of terms ro,ri by 12 to convert to ft
//      Multiplication of term S by (2*pi/60) to convert to rad/s
//      Division of the whole term by 32.174 to convert to fl.lb/lbm

end Ex12_7;
//===================================================================
