// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-2: Fluid Statics
//Example: 2.10 Page 72
// Title: Buoyant Force on a Submerged Object
//===================================================================
model Ex2_10

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V(unit = "ft^3")"Minimum volume of foam needed for life jacket";

//=============
// Parameter Section 

parameter Real SW_water(unit = "lb/ft^3")=64.0"Specific weight of water";
parameter Real SW_foam(unit = "lb/ft^3")=2.0"Specific weight of foam";
parameter Real W(unit = "lb")=1.3"Weight of remaining material other than foam";
parameter Real F(unit = "lb")=22"Force required by the use";

//=============
// Equation Section 

equation
V =  (W+F)/(SW_water-SW_foam);//Calculation of minimum volume of foam needed for life jacket 

end Ex2_10;
//===================================================================
