// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-2: Fluid Statics
//Example: 2.4 Page 54
// Title: Simple U-Tube Manometer
//===================================================================
model Ex2_4

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_gage(unit = "lb/in^2")"Gage Pressure of air";

//=============
// Parameter Section 

parameter Real SG_mercury(unit = "")=13.6"Specific gravity of mercury";
parameter Real SG_oil(unit = "")=0.9"Specific gravity of oil";
parameter Real SW_water(unit = "lb/ft^3")=62.4"Specific weight of water"; 
parameter Real h1(unit = "in")=36"Column height 1";
parameter Real h2(unit = "in")=6"Column height 2";
parameter Real h3(unit = "in")=9"Column height 3";
//=============
// Equation Section 

equation
P_gage = (-(SG_oil*SW_water*((h1+h2)/12)) + (SG_mercury*SW_water*(h3/12)))/144; 
//Calculation of gauge pressure of air based on given problem setup (Refer Figure E2.4 Page No. 52)
//Note: Division of colum heights by 12 to convert the heights to ft
//      Division of the whole expression by 144 to convert P_gage to psi units

end Ex2_4;
//===================================================================
