// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-2: Fluid Statics
//Example: 2.6 Page 63
// Title: Hydrostatic Force on a Plane Circular Surface
//===================================================================
model Ex2_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F_R(unit = "N")"Magnitude of force of the water";
Real y(unit = "m") "Distance below shaft to center of pressure";
Real H(unit = "m")"Vertical distance from the fluid surface to the center of pressure";
Real M(unit ="N.m")"Moment required to open the gate";

//=============
// Parameter Section 

parameter Real SW_water(unit = "kN/m^3")=9.80"Specific weight of the flowing fluid";
parameter Real D(unit = "m")=4"Diameter of circular gate";
parameter Real h(unit = "m")=10"Vertical distance from the fluid surface to the centroid of the circular area";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
F_R = (SW_water*1000)*h*(pi*D);//Calculation of magnitude of force of the water
//Note: Multiplication of SW-water by 1000 to convert to N/m^3

H = ((pi/4)*(D/2)^4)/((h/sin(pi/3))*(pi*D)) + (h/sin(pi/3)); //Calculation of Vertical distance from the fluid surface to the center of pressure
//Note: The gate is inclined at an angle of 60 deg with horizontal
//      The Diameter 'D' is divided by 2 to get the radius

y = H - (h/sin(pi/3));//Calculation of distance below shaft to center of pressure

M = F_R*(y); //Calcultion of the moment required to open the gate

end Ex2_6;
//===================================================================
