// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.12 Page 129
// Title: Sluice Gate
//===================================================================
model Ex3_12

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Q_b(unit = "m^2/s")"Flowrate per unit width of the channel";
Real C_c(unit = "")"Contraction coefficient";
Real z2(unit = "m")"Water depth in the downstream of the channel";

//=============
// Parameter Section 

parameter Real a(unit = "m")=0.8"Gate Opening";
parameter Real z1(unit = "m")=5.0"Water depth in the upstream of the channel";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";

//=============
// Equation Section 

equation
C_c = 0.61;//Calculation of Contraction coefficient
//Note: Here the value of C_c is 0.61 because the ratio a/z1 = 0.16 < 0.20. Refer Page 129.

z2 = C_c * a;//Calculation of water depth in the downstream of the channel

Q_b = z2 * sqrt((2*g*(z1-z2))/(1 - (z2/z1)^2));//Calculation of flowrate per unit width of the channel
end Ex3_12;
//===================================================================
