// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.8 Page 122
// Title: Flow from a Tank—Pressure
//===================================================================
model Ex3_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real rho(unit = "kg/m^3")"Density of air in the tank";
Real Q(unit = "m^3/s")"Flowrate in the hose";
Real V_2(unit = "m/s")"Velocity in the hose";
Real V_3(unit = "m/s")"Velocity of the jet from nozzle";
Real P_2(unit = "N/m^2")"Pressure in the hose";

//=============
// Parameter Section 

parameter Real D(unit = "m")=0.03"Diameter of hose";
parameter Real d(unit = "m")=0.01"Diameter of nozzle";
parameter Real P_1(unit = "kN/m^2")=3.0"Pressure in the tank";
parameter Real R(unit = "N.m/kg.K")=286.9"Gas constant";
parameter Real P_atm(unit = "kN/m^2")=101"Gas constant";//Atmospheric pressure is assumed
parameter Real T_1(unit = "C")=15"Temperature inside tank"; //Atmospheric conditions is assumed
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
rho = ((P_1 + P_atm)*1000)/(R*(T_1+273));//Calculation of density of air in the tank
//Note: Multiplication of P_1 and P_atm by 1000 to convert to N/m^2
//      Addition of T_1by 273 to convert to K

V_3 = sqrt ((2*(P_1*1000))/rho);//Calculation of velocity of the jet from nozzle
//Note: Multiplication of P_1 by 1000 to convert to N/m^2

Q = ((pi/4)*d^2)*V_3;//Calculation of flowrate in the hose
//Note: According to continuity equation flow rate in the hose is same as flow rate in nozzle

V_2 = (d/D)^2*V_3;//Calculation of velocity in the hose
//Note: The expression arrived based on continuity equation

P_2 = (P_1*1000) - ((rho*(V_2)^2)/2);//Calculation of pressure in the hose
//Note: Multiplication of P_1 by 1000 to convert to N/m^2
//The expressio is arrived based on Bernouli equation

end Ex3_8;
//===================================================================
