// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.13 Page 219
// Title: Linear Momentum—Pressure, Change in Speed, and Friction
//===================================================================
model Ex5_13

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F(unit = "lb")"Frictional force exerted by the pipe wall";
Real m(unit = "lbm/s")"Mass flow rate";

//=============
// Parameter Section 

parameter Real D(unit = "in")=4"Diameter of pipe";
parameter Real V_2(unit = "ft/s")=1000"Air velocity at section 2";
parameter Real V_1(unit = "ft/s")=219"Air velocity at section 1";
parameter Real P_1(unit = "psi")=100"Pressure at section 1";
parameter Real P_2(unit = "psi")=18.4"Pressure at section 2";
parameter Real R(unit = "ft.lb/lbm.R")=53.5"Gas constant";
parameter Real T_1(unit = "R")=540"Temperature at section 1";
parameter Real T_2(unit = "R")=453"Temperature at section 2";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

m = ((P_2*144)/(R*T_2))*((pi/4)*(D^2/144)*V_2);//Calculation of mass flow rate
//Note: Multiplication of P_2 term by 144 to convert to lb/ft^2
//      Division of D^2 term by 144 to convert to ft^2

F = ((pi/4)*(D)^2*(P_1-P_2))-((m*(V_2-V_1))/32.174);//Calcualtion of frictional force exerted by the pipe wall
//Note: Division of m term by 32.174 to convert to lb.s^2

end Ex5_13;
//===================================================================
