// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.21 Page 239
// Title: Energy—Turbine Power per Unit Mass of Flow
//===================================================================
model Ex5_21

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real W(unit = "kJ/kg")"Work output involved per unit mass of steam through-flow";

//=============
// Parameter Section 

parameter Real H_1(unit = "kJ/kg")=3348"Inlet steam enthalpy";
parameter Real H_2(unit = "kJ/kg")=2550"Exit steam enthalpy";
parameter Real V_1(unit = "m/s")=30"Inlet steam velocity";
parameter Real V_2(unit = "m/s")=60"Exit steam velocity";

//=============
// Equation Section 

equation

W = H_1 - H_2 + ((V_1^2-V_2^2)/(2*1000));//Calculation of work output involved per unit mass of steam through-flow 
//Note: Division of V_1^2,V_2^2 by 1000 to convert to kJ/kg

end Ex5_21;
//===================================================================
