// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.23 Page 242
// Title: Energy—Effect of Loss of Available Energy
//===================================================================
model Ex5_23

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Q1(unit = "m^3/s")"Volume flow rate for configuration 1";//Refer Figure E5.23a Page No. 242
Real Q2(unit = "m^3/s")"Volume flow rate for configuration 2";//Refer Figure E5.23a Page No. 242

//=============
// Parameter Section 

parameter Real D(unit = "mm")=120"Diameter of the opening";
parameter Real rho(unit = "kg/m^3")=1.23"Density of air";
parameter Real Kl_1(unit = "")=0.05"Loss coefficient for configuration 1";
parameter Real Kl_2(unit = "")=0.5"Loss coefficient for configuration 1";
parameter Real P_1(unit = "kPa")=1"Pressur at section 1";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

Q1 = ((pi/4)*(D/1000)^2)*sqrt((P_1*1000)/(rho*((1+Kl_1)/2)));
//Calculation of Volume flow rate for configuration 1
//Note: Division of term D by 1000 to convert to m
//      Multiplication of P_1 by 1000 to convert to Pa

Q2 = ((pi/4)*(D/1000)^2)*sqrt((P_1*1000)/(rho*((1+Kl_2)/2)));
//Calculation of Volume flow rate for configuration 2
//Note: Division of term D by 1000 to convert to m
//      Multiplication of P_1 by 1000 to convert to Pa

end Ex5_23;
//===================================================================
