// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.24 Page 244
// Title: Energy—Fan Work and Efficiency
//===================================================================
model Ex5_24

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real E(unit = "")"Aerodynamic efficiency of the fan";

//=============
// Parameter Section 

parameter Real W_in(unit = "kW")=0.4"Input work";
parameter Real D(unit = "m")=0.6"Diameter of axial stream of air";
parameter Real V(unit = "m/s")=12"Velocity of air";
parameter Real rho(unit = "kg/m^3")=1.23"Density of air";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

E = (V^2/2)/((W_in*1000)/(rho*V*(pi/4)*(D^2)));//Calculation of aerodynamic efficiency of the fan
//Note: Multilication of the term W_in by 1000 to convert to W

end Ex5_24;
//===================================================================
