// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.9 Page 210
// Title: Conservation of Mass—Deforming Control Volume
//===================================================================
model Ex5_9

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real h_t(unit = "ft/min")"Time rate of change of the depth of carbon dioxide";

//=============
// Parameter Section 

parameter Real l(unit = "ft")=10"Length of the trench";
parameter Real w(unit = "ft")=5"Width of the trench";
parameter Real d(unit = "ft")=8"Depth of the trench";
parameter Real Q(unit = "ft^3/min")=10"Carbon dioxide flowrate into the trench";

//=============
// Equation Section 

equation
h_t = Q/(l*w);//Calculation of time rate of change of the depth of carbon dioxide

end Ex5_9;
//===================================================================
