// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.1 Page 404
// Title: Laminar or Turbulent Flow
//===================================================================
model Ex8_1

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Vl_50(unit = "ft/s")"Laminar velocity of fluid at 50F";
Real Vl_140(unit = "ft/s")"Laminar velocity of fluid at 140F";
Real Vt_50(unit = "ft/s")"Turbulent velocity of fluid at 50F";
Real Vt_140(unit = "ft/s")"Turbulent velocity of fluid at 140F";
Real tl_50(unit = "s")"Time take to fill the liquid at 50F - Laminar";
Real tl_140(unit = "s")"Time take to fill the liquid at 140F - Laminar";
Real tt_50(unit = "s")"Time take to fill the liquid at 50F - Turbulent";
Real tt_140(unit = "s")"Time take to fill the liquid at 140F - Turbulent";

//=============
// Parameter Section 

parameter Real mu_50(unit = "lb.s/ft^2")=0.0000273"Viscosity of fluid at 50F";
parameter Real mu_140(unit = "lb.s/ft^2")=0.00000974"Viscosity of fluid at 140F";
parameter Real rho_50(unit = "slug/ft^3")=1.94"Viscosity of fluid at 50F";
parameter Real rho_140(unit = "slug/ft^3")=1.91"Viscosity of fluid at 140F";
parameter Real D(unit = "in")=0.73"Diameter of the pipe";
parameter Real V(unit = "ft^3")=0.0125"Volume of the glass jar";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

Vl_50 = (2100*mu_50)/(rho_50*(D/12));//Calculation of Laminar velocity of fluid at 50F
//Note: Division of term D by 12 to convert to ft

tl_50 = V/((pi/4)*(D/12)^2*Vl_50);//Calculation of Time take to fill the liquid at 50F - Laminar
//Note: Division of term D by 12 to convert to ft

Vl_140 = (2100*mu_140)/(rho_140*(D/12));//Calculation of Laminar velocity of fluid at 140F
//Note: Division of term D by 12 to convert to ft

tl_140 = V/((pi/4)*(D/12)^2*Vl_140);//Calculation of Time take to fill the liquid at 140F - Laminar
//Note: Division of term D by 12 to convert to ft

Vt_50 = (4000*mu_50)/(rho_50*(D/12));//Calculation of Turbulent velocity of fluid at 50F
//Note: Division of term D by 12 to convert to ft

tt_50 = V/((pi/4)*(D/12)^2*Vt_50);//Calculation of Time take to fill the liquid at 50F - Turbulent
//Note: Division of term D by 12 to convert to ft

Vt_140 = (4000*mu_140)/(rho_140*(D/12));//Calculation of Turbulent velocity of fluid at 140F
//Note: Division of term D by 12 to convert to ft

tt_140 = V/((pi/4)*(D/12)^2*Vt_140);//Calculation of Time take to fill the liquid at 140F - Turbulent
//Note: Division of term D by 12 to convert to ft

end Ex8_1;
//===================================================================
