// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.13 Page 453
// Title: Type III with Minor Losses, Determine Diameter
//===================================================================
model Ex8_13

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real f(start = 0.02, unit = "")"Friction factor";//Initial guess value is 0.02
Real D(unit = "ft")"Diameter of the pipe";
//(unit = "")"Friction factor";
Real Re(unit ="")"Reynolds Number";
Real r(unit ="")"Ratio of roughness with pipe diameter (e/D)";

//=============
// Parameter Section 

parameter Real Q(unit = "ft^3/s")=26"Flowrate of fluid";
parameter Real l(unit = "ft")=1700"Length of pipe";
parameter Real nu(unit = "lb.s/ft^2")=0.0000121"Viscoisty of fluid";
parameter Real e(unit = "ft")=0.0005"Roughness of pipe";

//=============
// Equation Section 

equation

f= (0.00152*D^5) - (0.00135*D);//Calculation of Diameter of the pipe

Re = ((Q/((pi/4)*D^2))*D)/nu;//Calculation of Reynolds Number

r = e/D;//Calculation of roughness ratio

(1/sqrt(f)) = -2.0*log10((r/3.7)+(2.15/(Re*sqrt(f))));//Calculation of friction factor
//Colebrrok Equation

end Ex8_13;
//===================================================================
