// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.2 Page 411
// Title: Laminar Pipe Flow
//===================================================================
model Ex8_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P(unit = "kPa")"Pressure drop";
Real theta(unit = "Deg")"Angle of the pipe in the hill";
Real P3(unit ="kPa")"Pressure at point 3";

//=============
// Parameter Section 

parameter Real mu(unit = "N.s/m^2")=0.4"Viscosity of fluid";
parameter Real D(unit = "m")=0.02"Diameter of the pipe";
parameter Real l(unit = "m")=10"Length of the pipe";
parameter Real Q(unit = "m^3/s")=0.00002"Volume flow rate";
parameter Real P1(unit ="kPa")=200"Pressure at point 1";
parameter Real rho(unit ="kg/^3")=900"Density of fluid";
parameter Real g(unit ="m/s^2")=9.81"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

P = ((128*mu*l*Q)/(pi*D^4))/1000;//Calculation of pressure drop
//Note: Division of the term on RHS by 1000 to convert P to kPa

theta = asin((-128*mu*Q)/(pi*rho*g*D^4))*(180/pi);//Calculation of angle of pipe incled in the hill

P3 = P1;//Calculation of pressure at point 3
//Note: Pressure along the line is same since 1 and 3 lie along horizontal their magnitude is equal.

end Ex8_2;
//===================================================================
