model Ex8_3_a
// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016
//Chapter-8: Viscous Flow in Pipes
//Example: 8.3.a Page 416
// Title: Laminar Pipe Flow Properties
//===================================================================
//===============
// Libraries
extends Modelica.Constants;
//=============
// Variable Section
Real K[6] (unit = {"ft^5/lb.s","ft^5/lb.s","ft^5/lb.s","ft^5/lb.s","ft^5/lb.s","ft^5/lb.s"}) "Calibration Constant" ;
Real mu[6] (unit = {"lb.s/ft^2","lb.s/ft^2","lb.s/ft^2","lb.s/ft^2","lb.s/ft^2","lb.s/ft^2"}) = {0.04, 0.019, 0.0038, 0.00044, 0.000092, 0.000023} "Viscoisty of Syrup";
Real T[6] (unit = {"F","F","F","F","F","F"}) = {60, 80, 100, 120, 140, 160} "Temperature";
//=============
// Equation Section
equation
for i in 1:6 loop
K[i] = (0.000016/mu[i]);
end for;
//After Simulation, click on "Array Parametric Plot" icon. Choose array T and K then the required graph K Vs T will be visible
end Ex8_3_a;
