// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.4 Page 425
// Title: Turbulent Pipe Flow Properties
//===================================================================
model Ex8_4

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real u(unit = "m/s")"Velocity of fluid in boundary layer";
Real V(unit = "m/s")"Velocity of fluid";
Real V_c(unit = "m/s")"Centerline velocity of fluid";
Real d(unit = "m")"thickness of boundary layer";
Real T_w(unit = "N/m^2")"wall shear stress";
Real T(unit = "N/m^2")"shear stress";
Real T_lam(unit = "N/m^2")"Laminar shear stress";
Real T_ratio(unit = "N/m^2")"Ratio of Turbulent to Laminar shear stress";
Real Ug(unit = "s^-1")"Velocity gradient";

//=============
// Parameter Section 

parameter Real nu(unit = "m^2/s")=0.00000104"Viscosity of fluid";
parameter Real D(unit = "m")=0.1"Diameter of the pipe";
parameter Real l(unit = "m")=1"Length of the pipe";
parameter Real r(unit = "m")=0.025"Radial distance in the pipe";
parameter Real Q(unit = "m^3/s")=0.04"Volume flow rate";
parameter Real Pg(unit ="kPa/m")=2.59"Pressure gradient";
parameter Real rho(unit ="kg/^3")=998"Density of fluid";
parameter Real g(unit ="m/s^2")=9.81"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

T_w = ((Pg*1000)*D)/(4*l);//Calculation of wall shear stress
//Note: Multiplication of term Pd by 1000 to convert to Pa

u = sqrt(T_w/rho);//Calculation of velocity in the boundary layer

d = (5*nu)/u;//Calculation of boundry layer thickness

V = Q/((pi/4)*D^2);//Calculation of velocity of fluid

V_c = 1.186 * V;//Calculation of centerline velocity

T = (2*T_w*r)/D;//Calculation of shear stress

Ug = -(V_c/(8.4*(D/2))*(1 - (r/(D/2)))^((1-8.4)/8.4));//Calculation of velocity gradient

T_lam = -(nu*rho*Ug);//Calculation of laminar shear stress

T_ratio = (T - T_lam)/T_lam;//Calculation of ratio of Turbulent to Laminar shear stress

end Ex8_4;
//===================================================================
