// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.5 Page 432
// Title: Comparison of Laminar and Turbulent Pressure Drop
//===================================================================
model Ex8_5

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_lam(unit = "kPa")"Pressure drop in laminar flow";
Real P_turb(unit = "kPa")"Pressure drop in turbulent flow";
Real f_lam(unit = "")"Friction factor in laminar flow";
Real f_turb(unit = "")"Friction factor in turbulent flow";

//=============
// Parameter Section 

parameter Real mu(unit = "N.s/m^2")=0.0000179"Viscosity of fluid";
parameter Real D(unit = "m")=0.004"Diameter of the pipe";
parameter Real l(unit = "m")=0.1"Length of the pipe";
parameter Real V(unit = "m/s")=50"Velocity of fluid";
parameter Real rho(unit ="kg/^3")=1.23"Density of fluid";
parameter Real g(unit ="m/s^2")=9.81"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

f_lam = 64/((rho*V*D)/mu);//Calculation of friction factor for laminar flow

P_lam = (f_lam*(l/D)*(1/2)*rho*V^2)/1000;//Calculation of pressure difference in laminar flow
//Note: Division of the expression by 1000 to convert RHS to kPa

f_turb = 0.028;//Calculation of friction factor for turbulent flow
//Note: The value is obtained from Moody chart Table 8.1 Page No. 817 

P_turb = (f_turb*(l/D)*(1/2)*rho*V^2)/1000;//Calculation of pressure difference in turbulent flow
//Note: Division of the expression by 1000 to convert RHS to kPa

end Ex8_5;
//===================================================================
