// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.6 Page 442
// Title: Minor Losses
//===================================================================
model Ex8_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real hl(unit = "ft")"Total Head loss";
Real P(unit = "psi")"Pressure drop";
Real W(unit = "hp")"Power added to the fluid";

//=============
// Parameter Section 

parameter Real g(unit ="ft/s^2")=32.2"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real L_diff(unit = "")=0.6"Loss Coefficient in diffuser";
parameter Real L_corner(unit = "")=0.2"Loss Coefficient in diffuser";
parameter Real L_nozzle(unit = "")=0.2"Loss Coefficient in diffuser";
parameter Real L_screen(unit = "")=4.0"Loss Coefficient in diffuser";
parameter Real V2(unit = "ft/s")=28.6"Velocity of fluid at point 2";
parameter Real V3(unit = "ft/s")=22.9"Velocity of fluid at point 3";
parameter Real V4(unit = "ft/s")=22.9"Velocity of fluid at point 4";
parameter Real V5(unit = "ft/s")=200.0"Velocity of fluid at point 5";
parameter Real A5(unit = "ft^2")=4.0"Area at 5";
parameter Real V6(unit = "ft/s")=200.0"Velocity of fluid at point 6";
parameter Real V7(unit = "ft/s")=80.0"Velocity of fluid at point 7";
parameter Real V8(unit = "ft/s")=44.4"Velocity of fluid at point 8";
parameter Real SW(unit = "lb/ft^3")=0.0765"Specific weight of fluid";
//=============
// Equation Section 

equation

hl = ((L_corner*(V7^2+V8^2+V2^2+V3^2)) + (L_diff*V6^2) + (L_nozzle*V5^2) + (L_screen*V4^2))/(2*g);
//Calculation of total head loss

P = (SW*hl)/144;//Calculation of total pressure drop
//Note: Division of the term by 144 to convert P to psi

W = (SW*A5*V5*hl)/550;//Calculation of power added to the fluid (only at section 5 ower is added)
//Note: Division of term by 550 to convert W to hp

end Ex8_6;
//===================================================================
