// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.7 Page 445
// Title: Noncircular Conduit
//===================================================================
model Ex8_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real a(unit = "in")"Duct size";
Real f(unit = "")"Friction factor";

//=============
// Parameter Section 

parameter Real D(unit = "in")=8"Diameter of the pipe";
parameter Real V(unit = "ft/s")=10"Velocity of fluid";

//=============
// Equation Section 

equation

f = 0.023;//Calculation of friction factor of the duct
//Note: Value is obtained from Moody chart from Fig. 8.20 in page no. 431 using trial and error method 

a = 1.30*(f)^(1/5)*12;//Calculation of duct size
//Note: The expression and derived and can be referred in page no. 445
//      Multiplication of the expression by 12 to convert a to in.

end Ex8_7;
//===================================================================
