// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-8: Viscous Flow in Pipes
//Example: 8.9 Page 447
// Title: Type I, Determine Pressure Drop
//===================================================================
model Ex8_9

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real h_p(unit = "ft")"Pressure head";
Real h_l(unit = "ft")"Minor loss";
Real f(unit = "")"Friction factor";
Real V(unit = "ft/s")"Velocity of fluid";
Real W(unit = "hp")"Actual power of the fan";
Real W_minor(unit = "hp")"Power of the fan considering minor loss";

//=============
// Parameter Section 

parameter Real SW(unit = "lb/ft^3")=0.0765"Specific weight of air";
parameter Real Q(unit = "ft^3/min")=600"Flow rate of air";
parameter Real l(unit = "ft")=30"Total length of pipe";
parameter Real D(unit = "in")=8"Diameter of pipe";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
 final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real Kle(unit = "")=0.5"Loss coefficient for entrance";
parameter Real Klb(unit = "")=1.1"Loss coefficient for bend";
parameter Real Klex(unit = "")=1.0"Loss coefficient for exit";

//=============
// Equation Section 

equation

V = (Q/60)/((pi/4)*(D/12)^2);//Calculation of velocity of fluid
//Note: Division of the term D by 12 to convert to ft
//      Division of the term Q by 60 to convert to ft^3/s

f = 0.017;//Calculation of friction factor
//Note: The above value is obtained from Moody chart

h_p = (f*(l/(D/12))*(V^2/(2*g)));//Calculation  of pressure head

W = (SW*(Q/60)*h_p)/550;//Calculation of actual power of the fan
//Note: Division of the term Q by 60 to convert to ft^3/s
//      Division of the whole expression by 500 to convert W to hp unit

h_l = ((V^2/(2*g))*(Kle+Klb+Klex));//Calculation of minor loss

W_minor = W + (SW*(Q/60)*h_l)/550;//Calculation of power of the fan considering minor loss
//Note: Division of the term Q by 60 to convert to ft^3/s
//      Division of the whole expression by 500 to convert W_minor to hp unit

end Ex8_9;
//===================================================================
