// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-1: Introduction
//Example: 1.2 Page 10
// Title: BG and SI Units
//===================================================================
model Ex1_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F(unit = "N")"Reaction Force exerted by space shuttle";
Real W(unit = "N")"Weight of the space shuttle";

//=============
// Parameter Section 

parameter Real m(unit = "kg")=36"Mass of the space shuttle";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real a(unit = "ft/s^2")=15"Acceleration of the space shuttle";

//=============
// Equation Section 

equation
W = (m*g);//Calculation of weight of space shuttle

F = W + (m*(a*0.3048));//Calculation of Reaction Force exerted by space shuttle
//Note: Multiplication of a by 0.3048 to convert to m/s^2

end Ex1_2;
//===================================================================
