// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-1: Introduction
//Example: 1.3 Page 13
// Title: Ideal Gas Law
//===================================================================
model Ex1_3

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_total(unit = "lb/in.^2")"Total Pressure of air";
Real rho(unit = "slugs/ft^3")"Density of air";
Real W(unit = "lb")"Weight of air";


//=============
// Parameter Section 

parameter Real P_abs(unit = "lb/in.^2")=14.7"Absolute pressure of air";
parameter Real P_gage(unit = "lb/in.^2")=50"Gage pressure of air";
parameter Real R(unit = "ft.lb/slug.R")=1716"Gas constant";
parameter Real T(unit = "F")=70"Temperature of air";
parameter Real V(unit = "ft^3")=0.84"Volume of air tank";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation
P_total = P_abs + P_gage;//Calculation of total pressure of air

rho = (P_total*144)/(1716*(T+460)); //Calculation of density of air
//Note: Multiplication of P_total by 144 to convert to lb/ft.^2
//      Addition of T by 460 to convert to R
W = rho*g*V;//Calculation of weight of air

end Ex1_3;
//===================================================================
