// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-1: Introduction
//Example: 1.4 Page 18
// Title: Viscosity and Dimensionless Quantities
//===================================================================
model Ex1_4

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real rho(unit = "Kg/m^3")"Density of fluid";
Real Re_SI(unit = "")"Reynolds number of fluid obtained using SI unit system for required parameters";
Real Re_BG(unit = "")"Reynolds number of fluid obtained using BG unit system for requires parameters";

//=============
// Parameter Section 

parameter Real rho_water(unit = "Kg/m^3")=1000"Density of water";
parameter Real SG(unit = "")=0.91"Specific gravity of fluid";
parameter Real V(unit = "m/s")=2.6"Mean velocity of fluid";
parameter Real D(unit = "mm")=25"Diameter of pipe";
parameter Real mu(unit = "N.s/m^2")=0.38"Dynamic viscosity of fluid";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation
rho = SG*rho_water;//Calculation of density of fluid

Re_SI = (rho*V*(D*0.001))/(mu); //Calculation of Reynolds number using SI unit for required parameters 
//Note: Multiplication of D by 0.001 to convert to m

Re_BG = ((rho*0.00194)*(V*3.281)*(D*0.003281))/(mu*0.02089);//Calculation of Reynolds number using BG unit for required parameters 
//Note: Multiplication of rho by 0.00194 to convert to slugs/ft^3
//      Multiplication of V by 3.281 to convert to ft/s
//      Multiplication of D by 0.003281 to convert to ft
//      Multiplication of mu by 0.02089 to convert to lb.s/ft^2

end Ex1_4;
//===================================================================
