// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-1: Introduction
//Example: 1.5 Page 19
// Title: Newtonian Fluid Shear Stress
//===================================================================
model Ex1_5

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Stress_bottom(unit = "lb/ft^2")"Shear stress at the bottom wall of parallel plates";
Real Stress_midplane(unit = "lb/ft^2")"Shear stress at the midplane of parallel plates";
Real y_bottom(unit = "in")"Vertical distance along bottom wall to determine shearing stress";
Real y_midplane(unit = "in")"Vertical distance along midplane to determine shearing stress";

//=============
// Parameter Section 

parameter Real mu(unit = "lb.s/ft^2")=0.04"Dynamic viscosity of fluid";
parameter Real h(unit = "in")=0.2"Height of the parallel plates from midplane"; //Refer Fig. E1.5a
parameter Real V(unit = "ft/s")=2"Velocity of fluid";

//=============
// Equation Section 

equation
y_bottom = -h;//Calculation of Vertical distance along bottom wall to determine shearing stress
              //Refere Fig. E1.5a Page 19

Stress_bottom = mu*(-(3*V*(y_bottom*1/12))/(h*(1/12))^2); //Shear stress at the bottom wall of parallel plates
//Note: Multiplication of h by 1/12 to convert to ft.
//      Multiplication of y_bottom by 1/12 to convert to ft.

y_midplane = 0;//Calculation of Vertical distance along the midplane to determine shearing stress
              //Refere Fig. E1.5a Page 19

Stress_midplane = mu*(-(3*V*(y_midplane*(1/12)))/(h*(1/12))^2); //Shear stress at the midplane of parallel plates
//Note: Multiplication of h by 1/12 to convert to ft.
//      Multiplication of y_midlane by 1/12 to convert to ft.

end Ex1_5;
//===================================================================
