// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-10: Open-Channel Flow
//Example: 10.6 Page 577
// Title: Uniform Flow, Variable Roughness
//===================================================================
model Ex10_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real A2(unit = "ft^2")"Area of flow domain section 2";
Real P2(unit = "ft")"Perimeter of flow domain section 2";
Real R2(unit = "ft")"Hydraulic radius of section 2";
Real Q(unit = "ft^3/s")"Flow rate";

//=============
// Parameter Section 

parameter Real S_o(unit = "")=0.002"Bottom slope";
parameter Real y1(unit = "ft")=0.8"Depth of water-1";
parameter Real y2(unit = "ft")=0.6"Depth of water-2";
parameter Real l(unit = "ft")=2"Length of trapizoid domain";
parameter Real A1(unit = "ft^2")=1.8"Area of section 1 and 3";//Table E10.6 Page No. 577
parameter Real R1(unit = "ft")=0.5"Hydraulic radius of section 1 and 3";//Table E10.6 Page No. 577
parameter Real g(unit ="ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation

A2 = (l*(y1+y2));//Calculation of area of flow domain

P2 = l + (2*y1);//Calculation of perimeter of flow domain

R2 = A2/P2;//Calculation of hydraulic radius

Q = ((1.49/0.020)*(A1)*((R1)^(2/3))*((S_o)^(1/2))) + ((1.49/0.015)*(A2)*((R2)^(2/3))*((S_o)^(1/2))) +    ((1.49/0.030)*(A1)*((R1)^(2/3))*((S_o)^(1/2)));//Calculation of flow rate

//Note: Refer Figure E10.6a to get clear picture on the expression

end Ex10_6;
//===================================================================
