// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.2 Page 616
// Title: Mach Number, Stagnation Properties, and Mach Number Tables
//========================================================================
model Ex11_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real M_a(unit = "")"Mach Number - a";
Real To_a(unit = "K")"Stagnation temperature - a";
Real Po_a(unit = "kPa")"Stagnation pressure - a";
Real M_b(unit = "")"Mach Number - b";
Real To_b(unit = "K")"Stagnation temperature - b";
Real Po_b(unit = "kPa")"Stagnation pressure - b";
Real M_c(unit = "")"Mach Number - c";
Real To_c(unit = "K")"Stagnation temperature - c";
Real Po_c(unit = "kPa")"Stagnation pressure - c";
Real C_a(unit = "m/s")"Speed of sound - a,b";
Real C_c(unit = "m/s")"Speed of sound - c";

//=============
// Parameter Section 

parameter Real T_10(unit = "K")=223.3"Temperature at 10km";
parameter Real T_1(unit = "K")=281.7"Temperature at 1km";
parameter Real P_10(unit = "kPa")=26.5"Pressure at 10km";
parameter Real P_1(unit = "kPa")=89.88"Pressure at 1km";
parameter Real V_a(unit = "m/s")=250"Velocity of airplane - a,c";
parameter Real V_b(unit = "m/s")=500"Velocity of airplane - b";
parameter Real k(unit = "")=1.4"Specific heat ratio";

//=============
// Equation Section 

equation

C_a = 20.05*sqrt(T_10);//Calculationof speed of sound - a

M_a = V_a/C_a;//Calculation of Mach Number - a

Po_a = P_10/0.633;//Calculation of Stagnation pressure - a
//Note: 0.633 is the pressure ratio obtained for Mach number M_a from Table D.1

To_a = T_10/0.878;//Calculation of stagnation temperature - a
//Note: 0.878 is the temperature ratio obtained for Mach number M_a from Table D.1

M_b = V_b/C_a;//Calculation of Mach Number - b

Po_b = P_10/0.212;//Calculation of Stagnation pressure - b
//Note: 0.212 is the pressure ratio obtained for Mach number M_b from Table D.1

To_b = T_10/0.642;//Calculation of stagnation temperature - b
//Note: 0.642 is the temperature ratio obtained for Mach number M_b from Table D.1

C_c = 20.05*sqrt(T_1);//Calculationof speed of sound - c

M_c = V_a/C_c;//Calculation of Mach Number - c

Po_c = P_1*(1 + (((k-1)/2)*M_c^2))^(k/(k-1));//Calculation of Stagnation pressure - c

To_c = T_1*(1 + (((k-1)/2)*M_c^2));//Calculation of stagnation temperature - c

end Ex11_2;
//===================================================================
