// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-11: Compressible Flow
//Example: 11.6 Page 629
// Title: Use of Isentropic Flow Functions, Graphs, and Tables
//========================================================================
model Ex11_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real T2(unit = "R")"Temperature at section 2";
Real P2(unit = "psi")"Pressure at section 2";
Real V2(unit = "ft/s")"Velocity at section 2";

//=============
// Parameter Section 

parameter Real T1(unit = "R")=559.7"Temperature at section 1";
parameter Real P1(unit = "psi")=50"Pressure at section 1";
parameter Real V1(unit = "ft/s")=500"Velocity at section 1";
parameter Real M2(unit = "")=1.8"Mach Number at section 2";
parameter Real k(unit = "")=1.4"Specific heat ratio";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
parameter Real R(unit = "ft.lb/lbm.R")=53.3"Gas constant";
parameter Real cp(unit = "ft.lb/lbm.R")=186.7"constant pressure constant";

//=============
// Equation Section 

equation

T2 = ((cp*T1)+(V1^2/(2*g)))/(cp+((k*R*M2^2)/2));//Calculation of temperature at section 2

V2 = (M2*49.07)*sqrt(T2);//Calculation of velocity in section 2

P2 = P1*((T2/T1)^(k/(k-1)));//Calculation of pressure in section 2

end Ex11_6;
//===================================================================
