// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-2: Fluid Statics
//Example: 2.1 Page 46
// Title: Pressure-Depth Relationship
//===================================================================
model Ex2_1

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_interface1(unit = "lb/ft^2")"Pressure at the interface in lb/ft^2";
Real P_interface2(unit = "lb/in^2")"Pressure at the interface in lb/in^2";
Real P_interface3(unit = "ft")"Pressure at the interface in ft";
Real P_bottom1(unit = "lb/ft^2")"Pressure at the tank bottom in lb/ft^2";
Real P_bottom2(unit = "lb/in^2")"Pressure at the tank bottom in lb/in^2";
Real P_bottom3(unit = "ft")"Pressure at the tank bottom in ft";


//=============
// Parameter Section 

parameter Real SG(unit = "")=0.68"Specific gravity of gasoline";
parameter Real SW_water(unit = "lb.ft^3")=62.4"Specific weight of water";
parameter Real h(unit = "ft")=17"Height of gasoline in tank";
parameter Real h_water(unit = "ft")=3"Height of water in tank";
parameter Real P_gage(unit = "lb/ft^2")=0"Gage pressure of air";

//=============
// Equation Section 

equation
P_interface1 = (SG*SW_water*h) + P_gage;//Calculation of pressure at the interface in lb/ft^2
P_interface2 = P_interface1 / 144;//Calculation of pressure at the interface in lb/in^2
//Note: Division of P_interface1 by 144 to convert to lb/in^2
P_interface3 = P_interface1 / SW_water;//Calculation of pressure at the interface in ft

P_bottom1 = (SW_water*h_water) + P_interface1;//Calculation of pressure at the tank bottom in lb/ft^2
P_bottom2 = P_bottom1 / 144;//Calculation of pressure at the tank bottom in lb/in^2
//Note: Division of P_bottom1 by 144 to convert to lb/in^2
P_bottom3 = P_bottom1 / SW_water;//Calculation of pressure at the tank bottom in ft

end Ex2_1;
//===================================================================
