// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-2: Fluid Statics
//Example: 2.2 Page 48
// Title: Incompressible and Isothermal Pressure–Depth Variations
//===================================================================
model Ex2_2

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Pratio_comp(unit = "")"Pressure ratio treating air as compressible fluid";
Real Pratio_incomp(unit = "")"Pressure ratio treating air as incompressible fluid";

//=============
// Parameter Section 

parameter Real P_abs(unit = "lb/in.^2")=14.7"Absolute pressure of air";
parameter Real SW(unit = "lb/ft^3")=0.0765"Specific weight of air";
parameter Real R(unit = "ft.lb/slug.R")=1716"Gas constant";
parameter Real T(unit = "F")=59"Temperature of air";
parameter Real h(unit = "ft")=2717"Difference in height between top and bottom";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";

//=============
// Equation Section 

equation
Pratio_comp = exp((g*h)/(R*(T+460)));//Calculation of Pressure ratio treating air as compressible fluid
//Note: Addition of T by 460 to convert to R 

Pratio_incomp = 1 - ((SW*h)/(P_abs*144));//Calculation of Pressure ratio treating air as incompressible fluid 
//Note: Multiplication of P_abs by 144 to convert to lb/ft^2

end Ex2_2;
//===================================================================
//The answer for pressure ratio (assuming fluid is compressible) is wrong
//The answer for pressure ratio (assuming fluid is incompressible) is rounded off in the textbook
