// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-2: Fluid Statics
//Example: 2.3 Page 51
// Title: Barometric Pressure
//===================================================================
model Ex2_3

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_o(unit = "kN/m^2")"Absolute pressure at the surface of lake";
Real P_o1(unit = "kN/m^2")"Absolute pressure at the deepest part of lake";

//=============
// Parameter Section 

parameter Real SW_mercury(unit = "kN/m^3")=133"Specific weight of water";
parameter Real SW_water(unit = "kN/m^3")=9.804"Specific weight of water"; //At temperature = 10 deg C
parameter Real h(unit = "m")=40"Maximum Depth of water in the lake";
parameter Real P_baro(unit = "mm")=598"Barometric Pressure in mm of Hg";

//=============
// Equation Section 

equation
P_o = (P_baro/1000)*SW_mercury;//Calculation of absolute pressure at the surface of lake
//Note: Division of P_baro by 1000 in order to convert to m

P_o1 = (SW_water*h) + P_o;//Calculation of absolute pressure at the deepest part of lake

end Ex2_3;
//===================================================================
