// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-2: Fluid Statics
//Example: 2.7 Page 64
// Title: Hydrostatic Pressure Force on a Plane Triangular Surface
//===================================================================
model Ex2_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F_R(unit = "lb")"Magnitude of force of the water";
Real y(unit = "ft")"Vertical distance from the fluid surface to the center of pressure";
Real x(unit = "ft")"Horizontal distance from the fluid surface to the center of pressure";
Real I_x(unit = "ft^4")"Moment of inertia in x-plane";
Real I_xy(unit = "ft^4")"Moment of inertia in xy-plane";

//=============
// Parameter Section 

parameter Real SW_water(unit = "lb/ft^3")=64.0"Specific weight of water";
parameter Real h(unit = "ft")=0.3"height of triangular surface";
parameter Real w(unit = "ft")=0.3"Width of triangular surface";
parameter Real h_c(unit = "ft")=0.9"Vertical distance from the fluid surface to the centroid of the triangular area";

//=============
// Equation Section 

equation
F_R = SW_water*h_c*((h*w)/2);//Calculation of magnitude of force of the water

I_x = (w*h^3)/36;//Calculation of moment of inertia in x-plane

y = I_x/(h_c*((h*w)/2)) + h_c;
//Calculation of vertical distance from the fluid surface to the center of pressure 

I_xy = (h^2*w^2)/72;//Calculation of moment of inertia in xy-plane

x = I_xy/(h_c*((h*w)/2));
//Calculation of horizontal distance from the fluid surface to the center of pressure 

end Ex2_7;
//===================================================================
