// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-2: Fluid Statics
//Example: 2.9 Page 69
// Title: Hydrostatic Pressure Force on a Curved Surface
//===================================================================
model Ex2_9

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F_H(unit = "N")"Horizontal force acting on curved section";
Real F_V(unit = "N")"Vertical force acting on curved section";
Real F_R(unit = "N")"Resultant force acting on curved section";
Real theta(unit = "Deg")"Angular location of resultant force from vertical";

//=============
// Parameter Section 

parameter Real SW(unit = "lb/ft^3")=62.4"Specific weight of fluid";
parameter Real D(unit = "ft")=6"Diameter of the conduit";
parameter Real l(unit = "ft")=1"Length of the conduit";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
F_H = (SW*(D/4)*((D/2)*l));
//Calculation of horizontal force acting on curved section
//Note: Division of D by 4 to get the distance of F_H from centroid of considered fluid element
//      Division of D by 2 to get the radius of conduit inorder to find area of fluid element acted     //      upon by horizontal force
//      Refer Figure E2.9 in page no. 67 to see the considered fluid element

F_V = (SW*((pi/4)*((D/2)^2)*l));
//Calculation of vertical force acting on curved section
//Note: Division of D by 2 to get the radius of conduit inorder to find volume of fluid element acted //      upon by vertical force

F_R = sqrt((F_H)^2 + (F_V)^2);
//Calculation of resultant force acting on curved section

theta = atan(F_H/F_V)*(180/pi);
//Calculation of angular location of resultant force from vertical 

end Ex2_9;
//===================================================================
