// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.11 Page 128
// Title: Venturi Meter
//===================================================================
model Ex3_11

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Pdiff_min(unit = "N/m^2")"Pressure difference for the smallest flowrate";
Real Pdiff_max(unit = "N/m^2")"Pressure difference for the largest flowrate";
Real rho(unit = "kg/m^3")"Density of oil";

//=============
// Parameter Section 

parameter Real SG(unit = "")=0.85"Specific gravity of oil";
parameter Real rho_water(unit = "kg/m^3")=1000"Density of water";
parameter Real D1(unit = "m")=0.1"Diameter-upstream of venturi Meter";
parameter Real D2(unit = "m")=0.06"Diameter-downstream of venturi Meter";
parameter Real Q_min(unit = "m^3/s")=0.005"Smallest flowrate";
parameter Real Q_max(unit = "m^3/s")=0.05"Largest flowrate";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
rho = SG * rho_water;//Calculation of the density of oil

Pdiff_min = ((Q_min)^2*rho*(1-(D2/D1)^4))/(2*((pi/4)*(D2)^2)^2);//Calculation of Pressure difference for the smallest flowrate

Pdiff_max = ((Q_max)^2*rho*(1-(D2/D1)^4))/(2*((pi/4)*(D2)^2)^2);//Calculation of Pressure difference for the largest flowrate

end Ex3_11;
//===================================================================
