// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.6 Page 116
// Title: Pitot-Static Tube
//===================================================================
model Ex3_6

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P_1(unit = "psi")"Pressure far ahead of the airplane"; //Refer Figure E3.6a Page No. 116
Real P_2(unit = "psi")"Pressure at the stagnation point - nose of the airplane";
Real P_diff(unit = "psi")"Pressure difference measured by Pitot tube";

//=============
// Parameter Section 

parameter Real rho(unit = "slug/ft^3")=0.001756"Density of fluid";
parameter Real V(unit = "mi/hr")=200"Velocity of airplane";

//=============
// Equation Section 

equation
P_1 = (1456)/144;// Refer Table C.1 Page No. 761 to find pressure at given altitude of 10,000 ft 
//Calculation of pressure far ahead of the airplane
//Note: Division of measured value (1456) by 144 to convert P_1 to psi unit

P_2 = ((P_1*144) + ((rho*(V*(5280/3600))^2)/2))/144;//Calculation of pressure at the stagnation point - nose of the airplane
//Note: Multiplication of P_1 by 144 to convert to lb/ft^2
//      Multiplication of V by 5280 to convert miles to feet
//      Division of V by 3600 to convert hours to seconds
//      Division of the whole expression by 144 to convert P_2 to psi unit

P_diff = P_2 - P_1;//Calculation of pressure difference measured by Pitot tube

end Ex3_6;
//===================================================================
//The answer for pressure value at stagnation point on the nose of the airplane is wrong
