// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016 

//Chapter-3: Elementary Fluid Dynamics—The Bernoulli Equation
//Example: 3.7 Page 121
// Title: Flow from a Tank—Gravity
//===================================================================
model Ex3_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V_2(unit = "m/s")"Velocity of beverage flowing out from cooler";//Refer Figure E3.7 Page No. 121
Real Q(unit = "m^3/s")"Flowrate from the bottle into cooler";

//=============
// Parameter Section 

parameter Real d(unit = "m")=0.01"Diameter of bottle";
parameter Real D(unit = "m")=0.2"Diameter of cooler";
parameter Real h(unit = "m")=0.2"Depth of beverage in the cooler";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
V_2 = sqrt ((2*g*h)/(1 - (d/D)^4));//Calculation of Velocity of beverage flowing out from cooler 

Q = ((pi/4)*d^2)*V_2;//Calculation of Flowrate from the bottle into cooler
//Note: Here using the continuity equation the flowrate from bottle into cooler is same as flowrate of fluid flowing out from cooler  

end Ex3_7;
//===================================================================
