// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.1 Page 116
// Title: Conservation of Mass—Steady, Incompressible Flow
//===================================================================
model Ex5_1

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Vol(unit = "ft^3")"Volume of the tank";
Real Q(unit = "ft^3/min")"Exchange rate of air in the tank";
Real V_out(unit = "ft/s")"Velocity of air exiting the tank";
Real V_in(unit = "ft/s")"Velocity of air entering the tank";

//=============
// Parameter Section 

parameter Real h(unit = "ft")=10"Height of tank";
parameter Real s(unit = "ft")=6"Size of the square base of the tank";
parameter Real D_in(unit = "in")=8"Inlet diameter of the hose";
parameter Real D_out(unit = "in")=4"Outlet diameter of the hose";
parameter Real t(unit = "min")=3"Air exchange rate";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation
Vol = h*(s*s);//Calculation of volume of the tank

Q = Vol/t;//Calculation of exchange rate of air in the tank

V_out = (Q / ((pi/4)*(D_out/12)^2))/60;//Calculation of velocity of air exiting the tank
//Note: Division of D_out by 12 to convert to ft
//      Division of the whole expression by 60 toconvert to ft/s

V_in = (Q / ((pi/4)*(D_in/12)^2))/60;//Calculation of velocity of air entering the tank
//Note: Division of D_in by 12 to convert to ft
//      Division of the whole expression by 60 toconvert to ft/s

end Ex5_1;
//===================================================================
