// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.11 Page 214
// Title: Linear Momentum—Weight, Pressure, and Change in Speed
//===================================================================
model Ex5_11

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F(unit = "N")"Anchoring force needed to hold the nozzle in place";
Real m(unit = "kg/s")"Mass flow rate";
Real w1(unit = "m/s")"Velocity at the entrance of control volume";//Refer Figure E5.11b Page No.214
Real w2(unit = "m/s")"Velocity at the exit of control volume";
Real W_nozzle(unit ="N")"Weight of nozzle";
Real W_water(unit ="N")"Weight of water carried by nozzle";

//=============
// Parameter Section 

parameter Real Q(unit = "lit/s")=0.6"Flow rate of water through the nozzle";
parameter Real D_in(unit = "mm")=16"Nozzle inlet diameter";
parameter Real D_ex(unit = "mm")=5"Nozzle exit diameter";
parameter Real M(unit = "kg")=0.1"Mass of the nozzle";
parameter Real h(unit = "mm")=30"Height of the tip of nozzle from control volume";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real P_1(unit = "kPa")=464"Pressure at section 1";
parameter Real rho(unit = "kg/m^3")=999"Density of water";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

m = rho*(Q*0.001);//Calculation of mass flow rate
//Note: Multiplication of Q by 0.001 to convert Q to m^3/s

w1 = (Q*0.001)/(((pi/4)*D_in^2)/(10^6));//Calculation of velocity at the entrance of control volume
//Note: Multiplication of Q by 0.001 to convert Q to m^3/s
//      Division of D_in^2 by 10^6 to convert to m^2

w2 = (Q*0.001)/(((pi/4)*D_ex^2)/(10^6));//Calculation of velocity at the exit of control volume
//Note: Multiplication of Q by 0.001 to convert Q to m^3/s
//      Division of D_ex^2 by 10^6 to convert to m^2

W_nozzle = M*g;//Calculation of Weight of nozzle

W_water = rho*((pi*(h/1000)*((D_in^2+D_ex^2+(D_in*D_ex))/10^6))/12)*g;//Calculation of weight of water carried by nozzle 
//Note: Division of h by 1000 to convert to m
//      Division by 10^6 to convert all the diameter to m

F = (m*(w1-w2))+W_nozzle+((P_1*1000)*((pi/4)*(D_in^2/10^6)))+W_water;//Calculation of anchoring force needed to hold the nozzle in place 

end Ex5_11;
//===================================================================
