// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.15 Page 221
// Title: Linear Momentum—Thrust
//===================================================================
model Ex5_15

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real F(unit = "N")"Nominal anchoring force";
Real m(unit = "kg/s")"Mass flow rate";
Real rho(unit = "kg/m^3")"Density of air";

//=============
// Parameter Section 

parameter Real A(unit = "m^2")=1"Intake cross-sectional area";
parameter Real V_1(unit = "m/s")=200"Intake air velocity";
parameter Real V_2(unit = "m/s")=500"Exhaust gas velocity";
parameter Real P_1(unit = "kPa")=-22.5"Intake static pressure";
parameter Real Pabs_1(unit = "kPa")=78.5"Intake absolute pressure";
parameter Real P_2(unit = "kPa")=0"Exhaust static pressure";
parameter Real Pabs_2(unit = "kPa")=101"Exhaust absolute pressure";
parameter Real T_1(unit = "K")=268"Intake static temperature";
parameter Real R(unit = "J/kg.K")=286.9"Gas constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

rho = (Pabs_1*1000)/(R*T_1);//Calculation of density of air
//Note: Multiplication of Pabs_1 term by 1000 to convert to Pa

m = rho*A*V_1;//Calculation of mass flow rate

F = -(A*(P_1*1000)) + m*(V_2-V_1);//Calculation of nominal anchoring force

end Ex5_15;
//===================================================================
