// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.19 Page 232
// Title: Moment-of-Momentum—Power
//===================================================================
model Ex5_19

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real m(unit = "slug/s")"Mass flow rate of air";
Real U_2(unit = "ft/s")"Rotor exit blade speed";
Real W_2(unit = "ft/s")"Speed of the fluid relative to nozzle";
Real V_2(unit = "ft/s")"Tangential speed";
Real W(unit = "hp")"Power required to run the fan)";

//=============
// Parameter Section 

parameter Real Q(unit = "ft^3/min")=230"Volume flow rate of air";
parameter Real D(unit = "in")=12"Outside diameter of the fan";
parameter Real d(unit = "in")=10"Inside diameter of the fan";
parameter Real H(unit = "in")=1"Height of the rotor blade";
parameter Real theta(unit = "Deg")=30"Blade discharge angle from tangential direction";
parameter Real S(unit = "rpm")=1725"Speed of the rotor";
parameter Real rho(unit = "slug/ft^3")=0.00238"Density of air";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

m = (Q/60)*rho;//Calculation of mass flow rate of air
//Note: Division of term Q by 60 to convert to ft^3/s

U_2 = ((D/2)/12)*(S*(2*pi/60));//Calculation of rotor exit blade speed
//Note: Division of term D/2 by 12 to convert to ft
//      Division of term S by (2*pi/60) to convert to rad/s

W_2 = (Q/60)/(2*pi*((D/2)/12)*(H/12)*sin(theta*(pi/180)));///Calculation of Speed of the fluid relative to nozzle
//Note: Division of term Q by 60 to convert to ft^3/s
//      Division of term D/2,H by 12 to convert to ft
//      Multiplication of theta by pi/180 to convert to radians

V_2 = U_2 - (W_2*cos(theta*(pi/180)));//Calculation of tangential velocity
//Note: Multiplication of theta by pi/180 to convert to radians

W = (m*V_2*U_2)/550;//Calculation of power required to run the fan
//Note: Division of term by 550 to convert to hp

end Ex5_19;
//===================================================================
