// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.20 Page 238
// Title: Energy—Pump Power
//===================================================================
model Ex5_20

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real m(unit = "lmb/s")"Mass flow rate of water";
Real V_1(unit = "ft/s")"Velocity at section 1";
Real V_2(unit = "ft/s")"Velocity at section 2";
Real W(unit = "hp")"Power required by pump";

//=============
// Parameter Section 

parameter Real Q(unit = "gal/min")=300"Volume flow rate of water";
parameter Real D_1(unit = "in")=3.5"Diameter at section 1";
parameter Real D_2(unit = "in")=1"Diameter at section 2";
parameter Real P_1(unit = "psi")=18"Diameter at section 1";
parameter Real P_2(unit = "psi")=60"Diameter at section 2";
parameter Real U(unit = "ft/lb/lbm")=93"Rise in internal energy";
parameter Real rho(unit = "slug/ft^3")=1.94"Density of water";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

m = (Q/(7.48*60))*(rho*32.74);//Calculation of mass flow rate of air
//Note: Division of term Q by 7.48*60 to convert to ft^3/s
//      Multiplication of rho by 32.74 to convert to lmb/ft^3

V_1 = (Q/(7.48*60)) / ((pi/4)*(D_1/12)^2);//Calculation of velocity at section 1
//Note: Division of term Q by 7.48*60 to convert to ft^3/s
//      Division of term D_1 by 12 to convert to ft

V_2 = (Q/(7.48*60)) / ((pi/4)*(D_2/12)^2);//Calculation of velocity at section 2
//Note: Division of term Q by 7.48*60 to convert to ft^3/s
//      Division of term D_2 by 12 to convert to ft

W = (m*(U + ((P_2*144)/(rho*32.74)) - ((P_1*144)/(rho*32.74)) + ((V_2^2 - V_1^2)/(2*32.174))))/550;
//Calculation of Power required by pump
//Note: Multiplication of P_2, P_1 by 144 to convert to lb/ft^2
//      Multiplication of rho by 32.174 to convert to lmb/ft^3
//      Division of the velocity term by 32.174 to convert to ft.lb/s
//      Division of term by 550 to convert to hp

end Ex5_20;
//===================================================================
