// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.25 Page 246
// Title: Energy—Head Loss and Power Loss
//===================================================================
model Ex5_25

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real Q(unit = "ft^3/s")"Flowrate";
Real W(unit "hp")"Power loss";

//=============
// Parameter Section 

parameter Real W_in(unit = "hp")=10"Input work";
parameter Real h_l(unit = "ft")=15"Head loss";
parameter Real H(unit = "ft")=30"Elevation difference between the lake surfaces";
parameter Real SW(unit = "lb/ft^3")=62.4"Specific weight of water";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

Q = ((W_in*550)/(SW*(h_l+H)));//Calculation of flowrate
//Note: Multiplication of term W_in by 550to convert to lb/s

W = (SW*Q*h_l)/550;//Calculation of power loss
//Note: Division of the term by 550 to convert W to hp

end Ex5_25;
//===================================================================
