// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.7 Page 208
// Title: Conservation of Mass—Relative Velocity
//===================================================================
model Ex5_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V(unit = "m/s")"Average speed of the water leaving the nozzle";

//=============
// Parameter Section 

parameter Real Q(unit = "ml/s")=1000"Flowrate of water entering sprinkler";
parameter Real A(unit = "mm^2")=30"Area of each of the two nozzles";

//=============
// Equation Section 

equation
V = (Q*0.001*10^6)/(1000*(2*A));//Calculation of average speed of the water leaving the nozzle
//Note: Multiplication of Q by 0.0001 and Division of Q by 1000 to convert unit of Q to m^3/s
//      Division of 2A by 10^6 to convert unit of A to m^2

end Ex5_7;
//===================================================================
