// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-5: Finite Control Volume Analysis
//Example: 5.8 Page 209
// Title: Conservation of Mass—Deforming Control Volume
//===================================================================
model Ex5_8

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real V(unit = "mm/min")"Velocity of the plunger in the syringe to prevent leakage";

//=============
// Parameter Section 

parameter Real Q(unit = "cm^3/min")=300"Injection rate of liquid from the syringe";
parameter Real A(unit = "mm^2")=500"Face area of the plunger";

//=============
// Equation Section 

equation
V = 1.1*((Q*1000)/A);//Calculation of velocity of the plunger in the syringe to prevent leakage
//Note: Multiplication of Q by 1000 to convert unit of Q to mm^3/min
//     Multiplication of the expression by 1.1 because it is given that leakage rate past the plunger //     is 0.10 times the volume flowrate out of the needle

end Ex5_8;
//===================================================================
