model Ex6_4_b
  // Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016
  //Chapter-6: Differential Analysis of Fluid Flow
  //Example: 6.4.b Page 299
  // Title: Velocity Potential and Inviscid Flow Pressure
  //===================================================================
  //===============
  // Libraries
  extends Modelica.Constants;
  //=============
  // Variable Section
  Real P_2(unit = "kPa") "Pressure at point 2 on the wall";
  //Refer Figure E6.4 Page No. 299
  Real V_1(unit = "m/s") "Square of Velocity at point 1";
  Real V_2(unit = "m/s") "Square of Velocity at point 2";
  //=============
  // Parameter Section
  parameter Real P_1(unit = "kPa") = 30 "Pressure at point 1";
  parameter Real r_1(unit = "m") = 1 "Distance of point 1 from the origin";
  parameter Real r_2(unit = "m") = 0.5 "Distance of point 2 from the origin";
  parameter Real rho(unit = "kg/m^3") = 1000 "Fluid density";
  //=============
  // Equation Section
equation
  V_1 = 16 * r_1 ^ 2;
//Calculation of sqyare of velocity at point 1
//Note: The expression is obtined from derivation in Page no. 300
  V_2 = 16 * r_2 ^ 2;
//Calculation of sqyare of velocity at point 2
//Note: The expression is obtined from derivation in Page no. 300
  P_2 = (P_1 * 1000 + rho / 2 * (V_1 - V_2)) / 1000;
//Calculation of pressure at point 2
//Note: Multiplication of P_1 by 1000 to convert to Pa
//      Division of the expression by  1000 to convert P_2 to kPa
end Ex6_4_b;
