// Gerhart et al., Munson, Young and Okiishi's Fundamentals of Fluid Mechanics, 8th Edn., John Wiley & Sons, Inc., 2016

//Chapter-6: Differential Analysis of Fluid Flow
//Example: 6.7 Page 311
// Title: Potential Flow—Half-body
//===================================================================
model Ex6_7

//===============
// Libraries 

extends Modelica.Constants;

//=============
// Variable Section 

Real P(unit = "psi")"Difference in pressure between point 1 and 2";//Refer Figure E6.7 Page No. 311
Real r_2(unit = "ft")"Distance of point 2 from the plane";
Real V_2(unit = "mi/hr")"Velocity at point 2";

//=============
// Parameter Section 

parameter Real V_1(unit = "mi/hr")=40"Velocity at point 1";
parameter Real H(unit = "ft")=200"Height of the hill";
parameter Real rho(unit = "slug/ft^3")=0.00238"Air density";
parameter Real g(unit = "ft/s^2")=32.2"Acceleration due to gravity";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=============
// Equation Section 

equation

V_2 = V_1*sqrt(1+(4/(pi^2)));//Calculation of Velocity at point 2
//Note: The velocity is calculated based on the expression given in Page No. 312

r_2 = H/2;//Calculation of distance of point 2 from the plane
//Note: The velocity is calculated based on the expression given in Page No. 312

P = (((rho/2)*((V_2*(5280/3600))^2 - (V_1*(5280/3600))^2)) + (rho*g*r_2))/144;//Calculation of difference in pressure between point 1 and 2
//Note: Multiplication of term V_2,V_1 by 5280/3600 to convert to ft/s
//      Division of term by 144 to convert p to psi

end Ex6_7;
//===================================================================
